// KBHook.cpp

#include <vcl.h>
#include "stdafx.h"
#include <stdio.h>
#include <windows.h>
#include <time.h>
#include <stdlib.h>
#define ID_Thread 0x128
//#define mDebugMode 1

//                  0    1    2    3    4    5    6    7    8    9    A
char Scancode1[]={0x00,0x43,0x41,0x3f,0x3d,0x3b,0x3c,0xda,0x64,0x44,0x42,
//                  B    C    D    E    F    10   11   12   13   14   15
                  0x40,0x3e,0x0f,0x29,0x59,0x65,0x38,0x2a,0x70,0x1d,0x10,
//                  16   17   18   19   1A   1B   1C   1D   1E   1F   20
                  0x02,0x5a,0x66,0x71,0x2c,0x1f,0x1e,0x11,0x03,0x5b,0x67,
//                  21   22   23   24   25   26   27   28   29   2A   2B
                  0x2e,0x2d,0x20,0x12,0x05,0x04,0x5c,0x00,0x39,0x2f,0x21,
//                  2C   2D   2E   2F   30   31   32   33   34   35   36
                  0x14,0x13,0x06,0x5d,0x69,0x31,0x30,0x23,0x22,0x15,0x07,
//                  37   38   39   3A   3B   3C   3D   3E   3F   40   41
                  0x5e,0x6a,0x72,0x32,0x24,0x16,0x08,0x09,0x5f,0x6b,0x33,
//                  42   43   44   45   46   47   48   49   4A   4B   4C
                  0x25,0x17,0x18,0x0b,0x0a,0x60,0x6c,0x34,0x35,0x26,0x27,
//                  4D   4E   4F   50   51   52   53   54   55   56   57
                  0x19,0x0c,0x61,0x6d,0x73,0x28,0x74,0x1a,0x0d,0x62,0x6e,
//                  58   59   5A   5B   5C   5D   5E   5F   60   61   62
                  0x3a,0x36,0x1c,0x1b,0x73,0x2b,0x63,0x76,0x55,0xd5,0x77,
//                  63   64   65   66   67   68   69   6A   6B   6C   6D
                  0x78,0x79,0x7a,0x0e,0x7b,0x7c,0x4f,0x7d,0x4b,0x47,0x7e,
//                  6E   6F   70   71   72   73   74   75   76   77   78
                  0x7f,0x6f,0x52,0x53,0x50,0x4c,0x4d,0x48,0x01,0x45,0xd9,
//                  79   7A   7B   7C   7D   7E
                  0x4e,0x51,0x4a,0x37,0x49,0x46};


// defein common data segment
struct MSRData//unsigned
{
    char MSRTrack1Data[256];
    char MSRTrack1Len;
    unsigned char MSRTrack1LRC;
    char MSRTrack2Data[256];
    char MSRTrack2Len;
    unsigned char MSRTrack2LRC;
    char MSRTrack3Data[256];
    char MSRTrack3Len;
    unsigned char MSRTrack3LRC;
    char MSRTrack4Data[256];
    char MSRTrack4Len;
    unsigned char MSRTrack4LRC;
};

struct MSRRegisterData
{
    unsigned int CapsLockKey;
    unsigned int LRCOnOff;
    unsigned int DebugMode;
    unsigned char MSRCardFormat[10];
    unsigned char MSRInterface[10];
    char Track1Pre;
    char Track1Post;
    char Track2Pre;
    char Track2Post;
    char Track3Pre;
    char Track3Post;
    char Track4Pre;
    char Track4Post;

    unsigned int TrackCount;
    char MSRPrefix[10];

    char MSRTrack1Prefix[10];
    char MSRTrack2Prefix[10];
    char MSRTrack3Prefix[10];
    char MSRTrack1Sufix[10];
    char MSRTrack2Sufix[10];
    char MSRTrack3Sufix[10];

    unsigned int ScanCodeOnOff;
    char MSRTrack1PreHex[10];
    char MSRTrack2PreHex[10];
    char MSRTrack3PreHex[10];
    char MSRTrack1SuHex[10];
    char MSRTrack2SuHex[10];
    char MSRTrack3SuHex[10];
    char MSRTerminator[5];
    unsigned int MSRDelayTime;
};

#pragma data_seg("DllHookData")
HINSTANCE hInstance=NULL;
HHOOK hhkHook=NULL;

HANDLE mGetTrack1DataEvent=NULL;
HANDLE mGetTrack2DataEvent=NULL;
HANDLE mGetTrack3DataEvent=NULL;
HANDLE mGetTrack4DataEvent=NULL;
HANDLE mThreadTerminated=NULL;
HANDLE mCharTimeEvent=NULL;

DWORD ThreadID=NULL;
HANDLE mIORWMutex=NULL;
HANDLE mTimerThread=NULL;
HANDLE mEndTrackProc=NULL;

time_t mMyTime=NULL;
long mOldWparam=NULL;
unsigned char mTrackCount=0;
bool mFirstTrack=false;
bool mSecondTrack=false;
bool mThirdTrack=false;
bool mForthTrack=false;
bool mShiftKey=false;
bool mCtrlKey=false;
bool mCapsKey=false;
bool mAltKey=false;
bool mPrefix1=false;
bool mPrefix2=false;
bool mPrefix3=false;
bool mSufix1=false;
bool mSufix2=false;
bool mSufix3=false;
bool mScanCodeMode=false;
bool mPrefixMode=false;
bool mPreCheck=false;
bool mTrack1PreCheck=false;
bool mTrack2PreCheck=false;
bool mTrack3PreCheck=false;
bool mTrack1SuCheck=false;
bool mTrack2SuCheck=false;
bool mTrack3SuCheck=false;
bool mTrack1PrefixMode=false;
bool mTrack2PrefixMode=false;
bool mTrack3PrefixMode=false;
bool mTrack1SufixMode=false;
bool mTrack2SufixMode=false;
bool mTrack3SufixMode=false;
bool mTrack1Exit=false;
bool mTrack2Exit=false;
bool mTrack3Exit=false;
bool mTrack1End=false;
bool mTrack2End=false;
bool mTrack3End=false;
int mNowCount=0;
int mPrefixCount=0;
int mTrack1PrefixCount=0;
int mTrack2PrefixCount=0;
int mTrack3PrefixCount=0;
int mTrack1SufixCount=0;
int mTrack2SufixCount=0;
int mTrack3SufixCount=0;
int mT1PrefixCount=0;
int mT2PrefixCount=0;
int mT3PrefixCount=0;
int mT1SufixCount=0;
int mT2SufixCount=0;
int mT3SufixCount=0;
int mPreCount=0;
char mTrack1PreHex[10];
char mTrack2PreHex[10];
char mTrack3PreHex[10];
char mTrack1SuHex[10];
char mTrack2SuHex[10];
char mTrack3SuHex[10];
char mTerminator[5];
unsigned int mDelayTime=0;
char mPrefixChar[10];
char mSufixChar[10];
char mTrack1PrefixChar[10];
char mTrack2PrefixChar[10];
char mTrack3PrefixChar[10];
char mTrack1SufixChar[10];
char mTrack2SufixChar[10];
char mTrack3SufixChar[10];
char mPreCharTemp[50];
char mSuCharTemp[50];
bool mKeyup=true;
bool mGetRegistry=false;
bool mLRCOnOff=false;
bool mGetLRC=false;
char mTrackData[]={'%','?',';','?','+','?','G','H',0};
HANDLE mCharRWMutex=NULL;
DWORD mOTime=0;
DWORD mETime=0;
bool mTimeOut=false;
int mCharCount=0;
MSRData tmpMyData;
int mCheckTimer=0;
int eTrackCount = 0;
bool mCheckTrackExit = false;
unsigned char TempChar[1];
bool mPadCheck = false;

#pragma data_seg()

#define OPOSMSRSOKey "SOFTWARE\\OLEforRetail\\ServiceOPOS\\MSR\\MSR"


LRESULT CALLBACK HookProc(int nCode,WPARAM wParam,LPARAM lParam);
DWORD WINAPI TimeOutProc(LPVOID lpParam);
DWORD WINAPI EndTrackProc(LPVOID lpParam);
void SaveTrackData(char mTrackCount);
void SendChar(void);
void SendDataChar(void);
void ChangeScanCode(char *scode);

BOOL APIENTRY DllMain( HANDLE hModule,
                       DWORD  ul_reason_for_call,
                       LPVOID lpReserved)
{
    DWORD  dwError;
    DWORD ExitThreadID=0;
    DWORD dwThrdParam = 1;
    ;
    HANDLE hShareMemory,hShareCountMemory;
    LPVOID lpShareMemoryAddress,lpShareCountMemoryAddress;
    HANDLE  hShareRegMemory;
    LPVOID  lpShareRegMemoryAddress;
    MSRRegisterData *RegData;
    MSRData *MyData;
    long *lCountData;
    long tmpCount=0;
    int i=0;
    hShareMemory=CreateFileMapping(INVALID_HANDLE_VALUE,
                                   NULL,
                                   PAGE_READWRITE,
                                   0,
                                   2048,
                                   "MSRData");
    dwError=GetLastError();
    hShareCountMemory=CreateFileMapping(INVALID_HANDLE_VALUE,
                                        NULL,
                                        PAGE_READWRITE,
                                        0,
                                        128,
                                        "MSRCountData");

    lpShareMemoryAddress=MapViewOfFile(hShareMemory,
                                       FILE_MAP_READ|FILE_MAP_WRITE,
                                       0,
                                       0,
                                       sizeof(MSRData));
    lpShareCountMemoryAddress=MapViewOfFile(hShareCountMemory,
                                            FILE_MAP_READ|FILE_MAP_WRITE,
                                            0,
                                            0,
                                            sizeof(long));
    MyData=(MSRData *)lpShareMemoryAddress;
    lCountData=(long *)lpShareCountMemoryAddress;




    if (ul_reason_for_call == DLL_PROCESS_ATTACH)
    {
        HKEY hKey=NULL;

        hShareRegMemory=CreateFileMapping(INVALID_HANDLE_VALUE,
                                          NULL,
                                          PAGE_READWRITE,
                                          0,
                                          sizeof(MSRRegisterData)+1,
                                          "MSRRegData");

        lpShareRegMemoryAddress=MapViewOfFile(hShareRegMemory,
                                              FILE_MAP_READ|FILE_MAP_WRITE,
                                              0,
                                              0,
                                              sizeof(MSRRegisterData));
        RegData=(MSRRegisterData *)lpShareRegMemoryAddress;
        //-----------------------------------------

        mScanCodeMode=false;

        strcpy(mTerminator,RegData->MSRTerminator);
        strcpy(mTrack1PreHex,RegData->MSRTrack1PreHex);

        if (mScanCodeMode)
            ChangeScanCode(mTrack1PreHex);

        if (mTrack1PreHex[0]==0)
        {
            mTrack1PrefixCount=0;
        }
        else
        {
            for (i=0;;i++)
            {

                if (mTrack1PreHex[i]==0 || i>=10)
                    break;
                mTrack1PrefixCount++;
            }
        }

        strcpy(mTrack2PreHex,RegData->MSRTrack2PreHex);
        if (mScanCodeMode)
            ChangeScanCode(mTrack2PreHex);

        if (mTrack2PreHex[0]==0)
        {
            mTrack2PrefixCount=0;
        }
        else
        {
            for (i=0;;i++)
            {

                if (mTrack2PreHex[i]==0 || i>=10)
                    break;
                mTrack2PrefixCount++;
            }
        }

        strcpy(mTrack3PreHex,RegData->MSRTrack3PreHex);
        if (mScanCodeMode)
            ChangeScanCode(mTrack3PreHex);

        if (mTrack3PreHex[0]==0)
        {
            mTrack3PrefixCount=0;
        }
        else
        {
            for (i=0;;i++)
            {

                if (mTrack3PreHex[i]==0 || i>=10)
                    break;
                mTrack3PrefixCount++;
            }
        }

        strcpy(mTrack1SuHex,RegData->MSRTrack1SuHex);

        if (mScanCodeMode)
            ChangeScanCode(mTrack1SuHex);

        if (mTrack1SuHex[0]==0)
        {
            mTrack1SufixCount=0;
        }
        else
        {
            for (i=0;;i++)
            {

                if (mTrack1SuHex[i]==0 || i>=10)
                    break;
                mTrack1SufixCount++;
            }
        }

        strcpy(mTrack2SuHex,RegData->MSRTrack2SuHex);
        if (mScanCodeMode)
            ChangeScanCode(mTrack2SuHex);

        if (mTrack2SuHex[0]==0)
        {
            mTrack2SufixCount=0;
        }
        else
        {
            for (i=0;;i++)
            {

                if (mTrack2SuHex[i]==0 || i>=10)
                    break;
                mTrack2SufixCount++;
            }
        }

        strcpy(mTrack3SuHex,RegData->MSRTrack3SuHex);
        if (mScanCodeMode)
            ChangeScanCode(mTrack3SuHex);

        if (mTrack3SuHex[0]==0)
        {
            mTrack3SufixCount=0;
        }
        else
        {
            for (i=0;;i++)
            {

                if (mTrack3SuHex[i]==0 || i>=10)
                    break;
                mTrack3SufixCount++;
            }
        }


        //TrackCount
        mTrackCount=RegData->TrackCount;
        mDelayTime=RegData->MSRDelayTime;

        if (RegData->LRCOnOff == 1)
            mLRCOnOff=true;
        else
        {
            mLRCOnOff=false;
        }
        // process caps lock key status
        PBYTE KeyState=new BYTE[256];
        GetKeyboardState(KeyState);
        if (KeyState[VK_CAPITAL])
            mCapsKey=true;
        else
            mCapsKey=false;

        UnmapViewOfFile(lpShareRegMemoryAddress);
        CloseHandle(hShareRegMemory);

        mGetTrack1DataEvent=CreateEvent(NULL,true,false,NULL);
        mGetTrack2DataEvent=CreateEvent(NULL,true,false,NULL);
        mGetTrack3DataEvent=CreateEvent(NULL,true,false,NULL);
        mGetTrack4DataEvent=CreateEvent(NULL,true,false,NULL);
        mThreadTerminated=CreateEvent(NULL,true,false,NULL);

        mCharTimeEvent = CreateEvent(NULL,true,false,NULL);
        mCharRWMutex = CreateMutex(NULL,false,"CharRWMutex");
        ReleaseMutex(mCharRWMutex);

        //common control between SO and Dll
        mIORWMutex=CreateMutex(NULL,false,"SHAREDATAIORWMutex"); // named mutex for common control
        WaitForSingleObject(mIORWMutex,INFINITE);
        memset(MyData->MSRTrack1Data ,0,256);
        memset(MyData->MSRTrack2Data ,0,256);
        memset(MyData->MSRTrack3Data ,0,256);
        memset(MyData->MSRTrack4Data ,0,256);
        MyData->MSRTrack1Len=0;
        MyData->MSRTrack1LRC=0;
        MyData->MSRTrack2Len=0;
        MyData->MSRTrack2LRC=0;
        MyData->MSRTrack3Len=0;
        MyData->MSRTrack3LRC=0;
        MyData->MSRTrack4Len=0;
        MyData->MSRTrack4LRC=0;
        tmpCount=*lCountData;
        tmpCount=0; // start data should be 0 
        *lCountData=tmpCount;
        ReleaseMutex(mIORWMutex);
        memset(tmpMyData.MSRTrack1Data ,0,256);
        memset(tmpMyData.MSRTrack2Data ,0,256);
        memset(tmpMyData.MSRTrack3Data ,0,256);
        memset(tmpMyData.MSRTrack4Data ,0,256);
        tmpMyData.MSRTrack1Len=0;
        tmpMyData.MSRTrack1LRC=0;
        tmpMyData.MSRTrack2Len=0;
        tmpMyData.MSRTrack2LRC=0;
        tmpMyData.MSRTrack3Len=0;
        tmpMyData.MSRTrack3LRC=0;
        tmpMyData.MSRTrack4Len=0;
        tmpMyData.MSRTrack4LRC=0;

        mTimerThread=CreateThread((LPSECURITY_ATTRIBUTES)0,1024,TimeOutProc,(LPVOID)0,CREATE_SUSPENDED,&ThreadID);
        ResumeThread(mTimerThread);
        mEndTrackProc=CreateThread((LPSECURITY_ATTRIBUTES)0,1024,EndTrackProc,(LPVOID)0,CREATE_SUSPENDED,&ThreadID);
        ResumeThread(mEndTrackProc);
    }
    else if (ul_reason_for_call == DLL_PROCESS_DETACH)
    {
        if (dwError == ERROR_ALREADY_EXISTS)
        {
            UnmapViewOfFile(lpShareMemoryAddress);
            CloseHandle(hShareMemory);
            UnmapViewOfFile(lpShareCountMemoryAddress);
            CloseHandle(hShareCountMemory);
        }
        CloseHandle(mGetTrack1DataEvent);
        CloseHandle(mGetTrack2DataEvent);
        CloseHandle(mGetTrack3DataEvent);
        CloseHandle(mGetTrack4DataEvent);
        CloseHandle(mIORWMutex);
        CloseHandle(mCharTimeEvent);
        CloseHandle(mTimerThread);
        CloseHandle(mCharRWMutex);
        CloseHandle(mEndTrackProc);
    }
    hInstance=(HINSTANCE)hModule;
    return TRUE;
}
//---------------------------------------------------------------------------
// EnableKeyboardCapture
extern "C" __declspec(dllexport) bool EnableKeyboardCapture()
{
    // process caps lock key status // correct position for detect

    PBYTE KeyState=new BYTE[256];
    GetKeyboardState(KeyState);
    if (KeyState[VK_CAPITAL])
        mCapsKey=true;
    else
        mCapsKey=false;


    if (!hhkHook)
    {
        hhkHook=SetWindowsHookEx(WH_KEYBOARD,(HOOKPROC)HookProc,hInstance,0);
    }

    if (!hhkHook)
        return false; // set hook success..
    if (mTimerThread) //yes
        ResumeThread(mTimerThread);

    if (mEndTrackProc)
        ResumeThread(mEndTrackProc);

    return true; // set hook fail
}
//---------------------------------------------------------------------------
// dll function
// DisableKeyboardCapture
extern "C" __declspec(dllexport) bool DisableKeyboardCapture()
{
    bool retval;
    retval=false;
    if (UnhookWindowsHookEx(hhkHook))
        retval=true;
    if (mTimerThread) //yes
        SuspendThread(mTimerThread);

    if (mEndTrackProc)
        SuspendThread(mEndTrackProc);

    return retval;
}

BOOL is_dead_key ( int wparam )
{
    unsigned int code = MapVirtualKey ( wparam, 2 );
    // Windows 95 retourne 0x8000, NT retourne 0x80000000
    return (code & 0x80008000) ? TRUE : FALSE;
}


LRESULT CALLBACK HookProc(int nCode,WPARAM wParam,LPARAM lParam)
{

    HWND hOtherWin=NULL;
    DWORD OtherThreadID=NULL;
    HWND hFocusWin=NULL;
    HWND result=NULL;
    MSG *keyMSG=(MSG *)lParam;
    unsigned char GetChar[1];
    unsigned char GetScanCode[1];
    static char nPad[10];
    static int mlen;
    GetChar[1]=0;
    GetScanCode[1]=0;

    if (nCode<0 || nCode == HC_NOREMOVE)
        return CallNextHookEx(hhkHook,nCode,wParam,lParam);

    GetChar[0]=(unsigned char)LOWORD(wParam);
    GetScanCode[0]=(unsigned char)HIWORD(lParam);  //scan code

    if (lParam & 0x20000000 && !mAltKey && !mPadCheck)
    {
        mAltKey=true;
#ifdef mDebugMode
        OutputDebugString("ALT Down");
#endif
        return CallNextHookEx(hhkHook,nCode,wParam,lParam);
    }
    if (mAltKey && (lParam & 0x80000000) && !(lParam & 0x20000000) )
    {
        mAltKey=false;
        mPadCheck=true;
#ifdef mDebugMode
        OutputDebugString("ALT UP");
#endif
    }


    if ((HIWORD(lParam) & 0x8000) && !mPadCheck ) // if wm-keyup , skip data
        return CallNextHookEx(hhkHook,nCode,wParam,lParam);

    if ( ((DWORD)lParam & 1<<30) != FALSE  && !mPadCheck)
        return CallNextHookEx(hhkHook,nCode,wParam,lParam);

    if (GetChar[0]==VK_LEFT || GetChar[0]==VK_RIGHT || GetChar[0]==VK_UP || GetChar[0]==VK_DOWN)
        return CallNextHookEx(hhkHook,nCode,wParam,lParam);

    if (GetChar[0]==VK_CONTROL  && !mPadCheck)
        return CallNextHookEx(hhkHook,nCode,wParam,lParam);

    if (GetChar[0]==VK_SHIFT  && !mPadCheck) // shift key be pressed
        return CallNextHookEx(hhkHook,nCode,wParam,lParam);

    if (GetChar[0]==VK_CAPITAL  && !mPadCheck) // caps lock key be pressed
        return CallNextHookEx(hhkHook,nCode,wParam,lParam);

    if (GetChar[0]==VK_MENU  && !mPadCheck) // Alt key by pressed
        return CallNextHookEx(hhkHook,nCode,wParam,lParam);

    if ( is_dead_key ( (UINT) wParam )  && !mPadCheck) // Dead keys be pressed
        return CallNextHookEx(hhkHook,nCode,wParam,lParam);



    //-----Scan to ASCII
    static   HKL   layout=GetKeyboardLayout(0);
    BYTE keyStateArr[256];
    WORD word;
    UINT scanCode = lParam;
    memset ( keyStateArr, 0, sizeof(keyStateArr) );


    if (GetKeyboardState(keyStateArr))
    {
        ToAsciiEx(wParam, scanCode, keyStateArr, &word, 0,layout);
        GetChar[0] = (char) word;
        if ((GetKeyState(VK_SHIFT) & 0x8000) && wParam >= 'a' && wParam <= 'z')
            GetChar[0] += 'A'-'a';

        //check (ALT + numbric keypad) input ASCII code
        if (mAltKey && (GetScanCode[0]>=0x47) && (GetScanCode[0]<=0x52))
        {
            nPad[mlen++] = GetChar[0];
#ifdef mDebugMode
            OutputDebugString("nPad s");
#endif
            return CallNextHookEx(hhkHook,nCode,wParam,lParam);
        }

        if (nPad[0]!=0 && !mAltKey)
        {
            GetChar[0] = (char)atoi(nPad);
#ifdef mDebugMode
            OutputDebugString("nPad e");
#endif
            memset ( nPad, 0, sizeof(nPad) );
            mlen=0;
            mPadCheck=false;
        }

#ifdef mDebugMode   // display scan code
        char att[50];
        sprintf(att,"Scan code2=%X , Ascii2=%X , char=%c",GetScanCode[0],GetChar[0],GetChar[0]);
        OutputDebugString(att);
#endif

        
        if (!mScanCodeMode)
            GetScanCode[0]=GetChar[0];

        if (mT1PrefixCount>10)
            mT1PrefixCount=0;
        if (mT2PrefixCount>10)
            mT2PrefixCount=0;
        if (mT3PrefixCount>10)
            mT3PrefixCount=0;
        if (mT1SufixCount>10)
            mT1SufixCount=0;
        if (mT2SufixCount>10)
            mT2SufixCount=0;
        if (mT3SufixCount>10)
            mT3SufixCount=0;

        //check terminal
        if ((mTrack1End || mTrack2End || mTrack3End) && mTerminator[0]!=0)
        {
            if (GetChar[0]==mTerminator[0] || GetChar[0]==mTerminator[1])
            {
                if (GetChar[0]==mTerminator[0] && mTerminator[1]==0)
                {
                    mTrack1End=false;
                    mTrack2End=false;
                    mTrack3End=false;
                }
                if (GetChar[0]==mTerminator[1])
                {
                    mTrack1End=false;
                    mTrack2End=false;
                    mTrack3End=false;
                }
                return 1;
            }
            else
            {
                mTrack1End=false;
                mTrack2End=false;
                mTrack3End=false;
            }

        }

        //check end
        if (mFirstTrack && GetScanCode[0]==mTrack1SuHex[mT1SufixCount])
        {
#ifdef mDebugMode
            OutputDebugString("T1 end check");
#endif
            mOTime = GetTickCount();
            mT1SufixCount++;
            if (mT1SufixCount==mTrack1SufixCount)
            {
#ifdef mDebugMode
                OutputDebugString("T1 end");
#endif
                ResetEvent(mCharTimeEvent);
                mTrack1Exit=true;
                mT1SufixCount=0;
                mT2SufixCount=0;
                mT3SufixCount=0;

                tmpMyData.MSRTrack1Data[mCharCount]=GetChar[0];

                mCharCount++;
                tmpMyData.MSRTrack1Data[mCharCount]=0;

                tmpMyData.MSRTrack1Len=(char)(mCharCount-1);

                mFirstTrack=false;
                mTrack1End=true;

                SaveTrackData(1);
                mETime = GetTickCount();
                SetEvent(mGetTrack1DataEvent);
            }
            return 1;
        }
        else
        {
            if (mT1SufixCount!=0)
                mT1SufixCount=0;
            mOTime = GetTickCount();
        }


        if (mSecondTrack && GetScanCode[0]==mTrack2SuHex[mT2SufixCount])
        {
#ifdef mDebugMode
            OutputDebugString("T2 end check");
#endif
            mOTime = GetTickCount();
            mT2SufixCount++;
            if (mT2SufixCount==mTrack2SufixCount)
            {
#ifdef mDebugMode
                OutputDebugString("T2 end");
#endif
                ResetEvent(mCharTimeEvent);
                mTrack2Exit=true;
                mT1SufixCount=0;
                mT2SufixCount=0;
                mT3SufixCount=0;

                tmpMyData.MSRTrack2Data[mCharCount]=GetChar[0];

                mCharCount++;
                tmpMyData.MSRTrack2Data[mCharCount]=0;

                tmpMyData.MSRTrack2Len=(char)(mCharCount-1);


                mSecondTrack=false;
                mTrack2End=true;

                SaveTrackData(2);
                mETime = GetTickCount();
                SetEvent(mGetTrack2DataEvent);


            }
            return 1;
        }
        else
        {
            if (mT2SufixCount!=0)
                mT2SufixCount=0;
            mOTime = GetTickCount();
        }


        if (mThirdTrack && GetScanCode[0]==mTrack3SuHex[mT3SufixCount])
        {
#ifdef mDebugMode
            OutputDebugString("T3 end check");
#endif
            mOTime = GetTickCount();
            mT3SufixCount++;
            if (mT3SufixCount==mTrack3SufixCount)
            {
#ifdef mDebugMode
                OutputDebugString("T3 end");
#endif
                ResetEvent(mCharTimeEvent);
                mTrack3Exit=true;
                mT1SufixCount=0;
                mT2SufixCount=0;
                mT3SufixCount=0;

                tmpMyData.MSRTrack3Data[mCharCount]=GetChar[0];

                mCharCount++;
                tmpMyData.MSRTrack3Data[mCharCount]=0;

                tmpMyData.MSRTrack3Len=(char)(mCharCount-1);


                mThirdTrack=false;
                mTrack3End=true;

                SaveTrackData(3);
                mETime = GetTickCount();
                SetEvent(mGetTrack3DataEvent);

            }
            return 1;
        }
        else
        {
            if (mT3SufixCount!=0)
                mT3SufixCount=0;
            mOTime = GetTickCount();
        }


        // track data
        if (mFirstTrack)
        {
#ifdef mDebugMode
            OutputDebugString("T1 data");
#endif
            mOTime = GetTickCount();
            tmpMyData.MSRTrack1Data[mCharCount]=GetChar[0];
            mCharCount++;
            mT1SufixCount=0;
            return 1;
        }
        if (mSecondTrack)
        { 
#ifdef mDebugMode
            OutputDebugString("T2 data");
#endif
            mOTime = GetTickCount();
            tmpMyData.MSRTrack2Data[mCharCount]=GetChar[0];
            mCharCount++;
            mT2SufixCount=0;
            return 1;
        }
        if (mThirdTrack)
        { 
#ifdef mDebugMode
            OutputDebugString("T3 data");
#endif
            mOTime = GetTickCount();
            tmpMyData.MSRTrack3Data[mCharCount]=GetChar[0];
            mCharCount++;
            mT3SufixCount=0;
            return 1;
        }


        //check start
        if (GetScanCode[0]==mTrack1PreHex[mT1PrefixCount] && mFirstTrack==false && mTrack1Exit==false)
        {
#ifdef mDebugMode
            OutputDebugString("T1 start check");
#endif
            mPreCharTemp[mT1PrefixCount]=GetChar[0];
            mT1PrefixCount++;
            mNowCount=mT1PrefixCount;
            mOTime = GetTickCount();
            SetEvent(mCharTimeEvent);

            if (mT1PrefixCount==mTrack1PrefixCount)
            { 
                ResetEvent(mGetTrack1DataEvent);
                ResetEvent(mGetTrack2DataEvent);
                ResetEvent(mGetTrack3DataEvent);
                ResetEvent(mGetTrack4DataEvent);

                mFirstTrack=true;
                mT1PrefixCount=0;
                mT2PrefixCount=0;
                mT3PrefixCount=0;

                memset(tmpMyData.MSRTrack1Data,0,256);

                mCharCount=0;
                tmpMyData.MSRTrack1Data[mCharCount]=GetChar[0];
                mCharCount++;


            }
            return 1;

        }
        else
        {
            if (mT1PrefixCount!=0)
            {
                SendChar();
                mT1PrefixCount=0;
                mOTime = GetTickCount();
            }
        }


        if (GetScanCode[0]==mTrack2PreHex[mT2PrefixCount] && mSecondTrack==false && mTrack2Exit==false)
        {
#ifdef mDebugMode
            OutputDebugString("T2 start check");
#endif
            mPreCharTemp[mT2PrefixCount]=GetChar[0];
            mT2PrefixCount++;
            mNowCount=mT2PrefixCount;
            mOTime = GetTickCount();
            SetEvent(mCharTimeEvent);

            if (mT2PrefixCount==mTrack2PrefixCount)
            { 
                ResetEvent(mGetTrack1DataEvent);
                ResetEvent(mGetTrack2DataEvent);
                ResetEvent(mGetTrack3DataEvent);
                ResetEvent(mGetTrack4DataEvent);

                mSecondTrack=true;

                mT1PrefixCount=0;
                mT2PrefixCount=0;
                mT3PrefixCount=0;

                memset(tmpMyData.MSRTrack2Data,0,256);

                mCharCount=0;
                tmpMyData.MSRTrack2Data[mCharCount]=GetChar[0];
                mCharCount++;

            }
            return 1;

        }
        else
        {
            if (mT2PrefixCount!=0)
            {
                SendChar();
                mT2PrefixCount=0;
                mOTime = GetTickCount();
            }
        }



        if (GetScanCode[0]==mTrack3PreHex[mT3PrefixCount] && mThirdTrack==false && mTrack3Exit==false)
        {
#ifdef mDebugMode
            OutputDebugString("T3 start check");
#endif
            mPreCharTemp[mT3PrefixCount]=GetChar[0];
            mT3PrefixCount++;
            mNowCount=mT3PrefixCount;
            mOTime = GetTickCount();
            SetEvent(mCharTimeEvent);

            if (mT3PrefixCount==mTrack3PrefixCount)
            { 
                ResetEvent(mGetTrack1DataEvent);
                ResetEvent(mGetTrack2DataEvent);
                ResetEvent(mGetTrack3DataEvent);
                ResetEvent(mGetTrack4DataEvent);

                mThirdTrack=true;

                mT1PrefixCount=0;
                mT2PrefixCount=0;
                mT3PrefixCount=0;

                memset(tmpMyData.MSRTrack3Data,0,256);

                mCharCount=0;
                tmpMyData.MSRTrack3Data[mCharCount]=GetChar[0];
                mCharCount++;

            }
            return 1;
        }
        else
        {
            if (mT3PrefixCount!=0)
            {
                SendChar();
                mT3PrefixCount=0;
                mOTime = GetTickCount();
            }
        }

    }
    return CallNextHookEx(hhkHook,nCode,wParam,lParam);
    //----------------------------------------------------------------------

}

void SaveTrackData(char mTrackCount)
{
    HANDLE hShareMemory,hShareCountMemory;
    LPVOID lpShareMemoryAddress,lpShareCountMemoryAddress;
    MSRData *MyData;
    long *lCountData;
    long tmpCount;
    char mGetTrackData;



    mGetTrackData=0x0;
    hShareMemory=CreateFileMapping(INVALID_HANDLE_VALUE,
                                   NULL,
                                   PAGE_READWRITE,
                                   0,
                                   2048,
                                   "MSRData");
    lpShareMemoryAddress=MapViewOfFile(hShareMemory,
                                       FILE_MAP_READ|FILE_MAP_WRITE,
                                       0,
                                       0,
                                       sizeof(MSRData));
    MyData=(MSRData *)lpShareMemoryAddress;
    WaitForSingleObject(mIORWMutex,INFINITE);

    if (!mCheckTrackExit)
    {
        memset(MyData->MSRTrack1Data,0,256);
        memset(MyData->MSRTrack2Data,0,256);
        memset(MyData->MSRTrack3Data,0,256);
        memset(MyData->MSRTrack4Data,0,256);
    }

    switch (mTrackCount)
    {
    case 1:
        mCheckTrackExit=true;
        mGetTrackData|=0x1;
        strcpy(MyData->MSRTrack1Data,tmpMyData.MSRTrack1Data);
#ifdef mDebugMode
        OutputDebugString("Save T1");
#endif


        if (mLRCOnOff)
            MyData->MSRTrack1LRC=tmpMyData.MSRTrack1LRC;

        MyData->MSRTrack1Len=tmpMyData.MSRTrack1Len;

        break;
    case 2:
        mCheckTrackExit=true;

        mGetTrackData|=0x2;
        strcpy(MyData->MSRTrack2Data,tmpMyData.MSRTrack2Data);
#ifdef mDebugMode
        OutputDebugString("Save T2");
#endif
        if (mLRCOnOff)
            MyData->MSRTrack2LRC=tmpMyData.MSRTrack2LRC;

        MyData->MSRTrack2Len=tmpMyData.MSRTrack2Len;
        break;
    case 3:
        mCheckTrackExit=true;

        mGetTrackData|=0x4;
        strcpy(MyData->MSRTrack3Data,tmpMyData.MSRTrack3Data);
#ifdef mDebugMode
        OutputDebugString("Save T3");
#endif

        if (mLRCOnOff)
            MyData->MSRTrack3LRC=tmpMyData.MSRTrack3LRC;

        MyData->MSRTrack3Len=tmpMyData.MSRTrack3Len;
        break;
    case 4:
        mCheckTrackExit=true;

        mGetTrackData|=0x8;
        strcpy(MyData->MSRTrack4Data,tmpMyData.MSRTrack4Data);

        if (mLRCOnOff)
            MyData->MSRTrack4LRC=tmpMyData.MSRTrack4LRC;

        MyData->MSRTrack4Len=tmpMyData.MSRTrack4Len;
        break;
    }
    UnmapViewOfFile(lpShareMemoryAddress);
    CloseHandle(hShareMemory);

    if (mGetTrackData) // means get data
    {
        // set event to enable share memory access
        hShareCountMemory=CreateFileMapping(INVALID_HANDLE_VALUE,
                                            NULL,
                                            PAGE_READWRITE,
                                            0,
                                            sizeof(long)+1,
                                            "MSRCountData");
        lpShareCountMemoryAddress=MapViewOfFile(hShareCountMemory,
                                                FILE_MAP_READ|FILE_MAP_WRITE,
                                                0,
                                                0,
                                                sizeof(long));
        lCountData=(long *)lpShareCountMemoryAddress;
        tmpCount=*lCountData;
        tmpCount++;
        if (tmpCount>255)
            tmpCount=0;

        *lCountData=tmpCount;
        UnmapViewOfFile(lpShareCountMemoryAddress);
        CloseHandle(hShareCountMemory);
    }

    ReleaseMutex(mIORWMutex);
}

void SendChar(void)
{
    HWND hOtherWin=NULL;
    DWORD OtherThreadID=NULL;
    HWND hFocusWin=NULL;
    HWND result=NULL;
    int i=0;

    hOtherWin = GetForegroundWindow();
    OtherThreadID = GetWindowThreadProcessId( hOtherWin, NULL);
    if ( AttachThreadInput( GetCurrentThreadId(), OtherThreadID, true ) )
    {
        hFocusWin = GetFocus();
        result = GetFocus();
        AttachThreadInput( GetCurrentThreadId(), OtherThreadID, false );
    }
    else
        result = GetFocus();


    for (i=0;i<=mNowCount-1;i++)
        SendMessage(result,WM_CHAR,mPreCharTemp[i],NULL);

    mNowCount=0;
    memset(mPreCharTemp,0,50);
}

void SendDataChar(void)
{
    HWND hOtherWin=NULL;
    DWORD OtherThreadID=NULL;
    HWND hFocusWin=NULL;
    HWND result=NULL;
    int i=0;

    hOtherWin = GetForegroundWindow();
    OtherThreadID = GetWindowThreadProcessId( hOtherWin, NULL);
    if ( AttachThreadInput( GetCurrentThreadId(), OtherThreadID, true ) )
    {
        hFocusWin = GetFocus();
        result = GetFocus();
        AttachThreadInput( GetCurrentThreadId(), OtherThreadID, false );
    }
    else
        result = GetFocus();

    if (mTrack1SuCheck)
    {
        mFirstTrack=false;
        for (i=0;i<=mCharCount-1;i++)
            SendMessage(result,WM_CHAR,tmpMyData.MSRTrack1Data[i],NULL);
    }
    if (mTrack2SuCheck)
    {
        mSecondTrack=false;
        for (i=0;i<=mCharCount-1;i++)
            SendMessage(result,WM_CHAR,tmpMyData.MSRTrack2Data[i],NULL);
    }
    if (mTrack3SuCheck)
    {
        mThirdTrack=false;
        for (i=0;i<=mCharCount-1;i++)
            SendMessage(result,WM_CHAR,tmpMyData.MSRTrack3Data[i],NULL);
    }
}

//Between the characters timerout process
DWORD WINAPI TimeOutProc(LPVOID lpParam)
{
    HWND hOtherWin=NULL;
    DWORD OtherThreadID=NULL;
    HWND hFocusWin=NULL;
    HWND result=NULL;
    int i=0;
    long mdifftime=0;

    while (1)
    {

        WaitForSingleObject(mCharTimeEvent,INFINITE);
        mdifftime = GetTickCount() - mOTime;

        if (mdifftime>=mDelayTime && mdifftime>0 )
        {

            hOtherWin = GetForegroundWindow();
            OtherThreadID = GetWindowThreadProcessId( hOtherWin, NULL);
            if ( AttachThreadInput( GetCurrentThreadId(), OtherThreadID, true ) )
            {
                hFocusWin = GetFocus();
                result = GetFocus();
                AttachThreadInput( GetCurrentThreadId(), OtherThreadID, false );
            }
            else
                result = GetFocus();

            if (!mFirstTrack && !mSecondTrack && !mThirdTrack && !mForthTrack)
            {
                for (i=0;i<=mNowCount-1;i++)
                    SendMessage(result,WM_CHAR,mPreCharTemp[i],NULL);

                mT1PrefixCount=0;
                mT2PrefixCount=0;
                mT3PrefixCount=0;
                memset(mPreCharTemp,0,50);
                ResetEvent(mCharTimeEvent);
            }
            else
            {
                if (mFirstTrack)
                {  
                    mFirstTrack=false;
                    for (i=0;i<=mNowCount-2;i++)
                        SendMessage(result,WM_CHAR,mPreCharTemp[i],NULL);
                    for (i=0;i<=mCharCount-1;i++)
                        SendMessage(result,WM_CHAR,tmpMyData.MSRTrack1Data[i],NULL);
                }
                if (mSecondTrack)
                {  
                    mSecondTrack=false;
                    for (i=0;i<=mNowCount-2;i++)
                        SendMessage(result,WM_CHAR,mPreCharTemp[i],NULL);
                    for (i=0;i<=mCharCount-1;i++)
                        SendMessage(result,WM_CHAR,tmpMyData.MSRTrack2Data[i],NULL);
                }
                if (mThirdTrack)
                {  
                    mThirdTrack=false;
                    for (i=0;i<=mNowCount-2;i++)
                        SendMessage(result,WM_CHAR,mPreCharTemp[i],NULL);
                    for (i=0;i<=mCharCount-1;i++)
                        SendMessage(result,WM_CHAR,tmpMyData.MSRTrack3Data[i],NULL);
                }
                if (mForthTrack)
                {
                    mForthTrack=false;
                    for (i=0;i<=mNowCount-2;i++)
                        SendMessage(result,WM_CHAR,mPreCharTemp[i],NULL);
                    for (i=0;i<=mCharCount-1;i++)
                        SendMessage(result,WM_CHAR,tmpMyData.MSRTrack4Data[i],NULL);
                }
            }
            mNowCount=0;
            mCharCount=0;
            ResetEvent(mCharTimeEvent);
        }

    }


    return 0;
}

DWORD WINAPI EndTrackProc(LPVOID lpParam)
{
    DWORD mWaitResult;
    long mdifftime ;

    HANDLE hSignal[4]={mGetTrack1DataEvent,
                       mGetTrack2DataEvent,
                       mGetTrack3DataEvent,
                       mGetTrack4DataEvent};
    while (1)
    {
        WaitForMultipleObjects(4,hSignal,false,INFINITE);

        HANDLE  hShareEndMemory;
        LPVOID  lpShareEndMemoryAddress;
        int *lEndData;

        hShareEndMemory=CreateFileMapping(INVALID_HANDLE_VALUE,
                                          NULL,
                                          PAGE_READWRITE,
                                          0,
                                          sizeof(int)+1,
                                          "MSREndData");
        lpShareEndMemoryAddress=MapViewOfFile(hShareEndMemory,
                                              FILE_MAP_READ|FILE_MAP_WRITE,
                                              0,
                                              0,
                                              sizeof(int));
        lEndData=(int *)lpShareEndMemoryAddress;
        *lEndData=0;

        mWaitResult=0;

        mWaitResult=WaitForSingleObject(hSignal[0],1); // fix  twice display or twice event detect
        if (mWaitResult==WAIT_OBJECT_0) // means wait for event done
        {   
            mdifftime = GetTickCount() - mETime;
            if (mdifftime>=200)
            {
                
                *lEndData=1;
                ResetEvent(mGetTrack1DataEvent);
                ResetEvent(mGetTrack2DataEvent);
                ResetEvent(mGetTrack3DataEvent);
                ResetEvent(mGetTrack4DataEvent);
                mCheckTrackExit = false;

                mTrack1Exit=false;
                mTrack2Exit=false;
                mTrack3Exit=false;

                memset(tmpMyData.MSRTrack1Data ,0,256);
                memset(tmpMyData.MSRTrack2Data ,0,256);
                memset(tmpMyData.MSRTrack3Data ,0,256);
                memset(tmpMyData.MSRTrack4Data ,0,256);
                tmpMyData.MSRTrack1Len=0;
                tmpMyData.MSRTrack1LRC=0;
                tmpMyData.MSRTrack2Len=0;
                tmpMyData.MSRTrack2LRC=0;
                tmpMyData.MSRTrack3Len=0;
                tmpMyData.MSRTrack3LRC=0;
                tmpMyData.MSRTrack4Len=0;
                tmpMyData.MSRTrack4LRC=0;
            }
        }

        mWaitResult=WaitForSingleObject(hSignal[1],1);
        if (mWaitResult==WAIT_OBJECT_0)
        {   
            mdifftime = GetTickCount() - mETime;
            if (mdifftime>=200)
            {
                *lEndData=2;
                ResetEvent(mGetTrack1DataEvent);
                ResetEvent(mGetTrack2DataEvent);
                ResetEvent(mGetTrack3DataEvent);
                ResetEvent(mGetTrack4DataEvent);
                mCheckTrackExit = false;

                mTrack1Exit=false;
                mTrack2Exit=false;
                mTrack3Exit=false;

                memset(tmpMyData.MSRTrack1Data ,0,256);
                memset(tmpMyData.MSRTrack2Data ,0,256);
                memset(tmpMyData.MSRTrack3Data ,0,256);
                memset(tmpMyData.MSRTrack4Data ,0,256);
                tmpMyData.MSRTrack1Len=0;
                tmpMyData.MSRTrack1LRC=0;
                tmpMyData.MSRTrack2Len=0;
                tmpMyData.MSRTrack2LRC=0;
                tmpMyData.MSRTrack3Len=0;
                tmpMyData.MSRTrack3LRC=0;
                tmpMyData.MSRTrack4Len=0;
                tmpMyData.MSRTrack4LRC=0;
            }
        }

        mWaitResult=WaitForSingleObject(hSignal[2],1);
        if (mWaitResult==WAIT_OBJECT_0)
        {   
            mdifftime = GetTickCount() - mETime;
            if (mdifftime>=200)
            {
                *lEndData=3;
                ResetEvent(mGetTrack1DataEvent);
                ResetEvent(mGetTrack2DataEvent);
                ResetEvent(mGetTrack3DataEvent);
                ResetEvent(mGetTrack4DataEvent);
                mCheckTrackExit = false;

                mTrack1Exit=false;
                mTrack2Exit=false;
                mTrack3Exit=false;

                memset(tmpMyData.MSRTrack1Data ,0,256);
                memset(tmpMyData.MSRTrack2Data ,0,256);
                memset(tmpMyData.MSRTrack3Data ,0,256);
                memset(tmpMyData.MSRTrack4Data ,0,256);
                tmpMyData.MSRTrack1Len=0;
                tmpMyData.MSRTrack1LRC=0;
                tmpMyData.MSRTrack2Len=0;
                tmpMyData.MSRTrack2LRC=0;
                tmpMyData.MSRTrack3Len=0;
                tmpMyData.MSRTrack3LRC=0;
                tmpMyData.MSRTrack4Len=0;
                tmpMyData.MSRTrack4LRC=0;
            }
        }

        mWaitResult=WaitForSingleObject(hSignal[3],1);
        if (mWaitResult==WAIT_OBJECT_0)
        {
            mdifftime = GetTickCount() - mETime;
            if (mdifftime>=200)
            {
                *lEndData=4;
                ResetEvent(mGetTrack1DataEvent);
                ResetEvent(mGetTrack2DataEvent);
                ResetEvent(mGetTrack3DataEvent);
                ResetEvent(mGetTrack4DataEvent);
                mCheckTrackExit = false;

                mTrack1Exit=false;
                mTrack2Exit=false;
                mTrack3Exit=false;

                memset(tmpMyData.MSRTrack1Data ,0,256);
                memset(tmpMyData.MSRTrack2Data ,0,256);
                memset(tmpMyData.MSRTrack3Data ,0,256);
                memset(tmpMyData.MSRTrack4Data ,0,256);
                tmpMyData.MSRTrack1Len=0;
                tmpMyData.MSRTrack1LRC=0;
                tmpMyData.MSRTrack2Len=0;
                tmpMyData.MSRTrack2LRC=0;
                tmpMyData.MSRTrack3Len=0;
                tmpMyData.MSRTrack3LRC=0;
                tmpMyData.MSRTrack4Len=0;
                tmpMyData.MSRTrack4LRC=0;
            }
        }

        UnmapViewOfFile(lpShareEndMemoryAddress);
        CloseHandle(hShareEndMemory);

    }

    return 0;
}

void ChangeScanCode(char *scode)
{
    int i;
    for (i=0;;i++)
    {
        if (scode[i]==0 || i>=10)
            break;

        scode[i]=Scancode1[scode[i]];

    }
}

